--TEST--
Phar::buildFromIterator() iterator, but object passed
--SKIPIF--
<?php if (!extension_loaded("phar")) die("skip"); ?>
--INI--
phar.require_hash=0
phar.readonly=0
--FILE--
<?php
class myIterator implements Iterator
{
    var $a;
    function __construct(array $a)
    {
        $this->a = $a;
    }
    function next() {
        echo "next\n";
        return next($this->a);
    }
    function current() {
        echo "current\n";
        return current($this->a);
    }
    function key() {
        echo "key\n";
        return key($this->a);
    }
    function valid() {
        echo "valid\n";
        return current($this->a);
    }
    function rewind() {
        echo "rewind\n";
        return reset($this->a);
    }
}
try {
	$phar = new Phar(dirname(__FILE__) . '/buildfromiterator3.phar');
	$phar->buildFromIterator(new myIterator(array()), new stdClass);
} catch (Exception $e) {
	var_dump(get_class($e));
	echo $e->getMessage() . "\n";
}
?>
===DONE===
--CLEAN--
<?php 
unlink(dirname(__FILE__) . '/buildfromiterator3.phar');
__HALT_COMPILER();
?>
--EXPECTF--
Warning: Phar::buildFromIterator() expects parameter 2 to be %string, object given in %sphar_buildfromiterator3.php on line %d
===DONE===
